;; An example boot sector.
;;
;; The boot sector is located on track 0, side 0,sector &41, and 
;; is executed with a |CPM command. A maximum of 512 bytes will be loaded to &100
;; in RAM. This sector *must* exist for the disc to be started with the |CPM command.
;; 
;; If the disc is formatted to SYSTEM or VENDOR format, then the directory 
;; will start on track 2, side 0, sector &41. Otherwise, the disc may use
;; a custom format for the remainder of track 0 and subsequent tracks.
;;
;; If a directory doesn't exist, then you must use sector read/write functions to load
;; data.
;;

;; The boot sector is loaded to &100 in memory and executed.

org &100

.km_wait_char equ &bb06
.txt_output equ &bb5a

;;------------------------------------------------------

;; display a message
ld hl,message
call print
;; wait for a keypress
call km_wait_char
;; soft-reset CPC
rst 0

;;------------------------------------------------------

.display_message
ld a,(hl)
inc hl
or a
ret z
call txt_output
jp display_message

;;------------------------------------------------------

.message 
defb "Hello, this is a boot sector program",0


